(function (window, undefined) {
    var old_onload = window.onload;
    window.onload = function () {
        const template = document.getElementById("content");
        Vue.prototype.lang = Object.assign(window.lang, window.module_lang);
        const host = location.origin;
        const fir = location.pathname.split("/")[1];
        const str = `${host}/${fir}`;
        new Vue({
            components: {
                comConfig,
            },
            data() {
                return {
                    formData: {
                        ylcdnaddon_can_update_account: '0',
                    },
                    submitLoading: false,
                    loading: false, // 数据加载状态
                };
            },
            created() {
                this.getIndexSetting();
            },
            computed: {},
            mounted() {},
            methods: {
                // 获取配置
                async getIndexSetting() {
                    this.loading = true;
                    try {
                        const res = await apiYlcdnGetConfig();
                        // 确保 res.data 和 res.data.data 存在
                        if (res && res.data && res.data.status === 200) {
                            const data = res.data.data || {};
                            // 使用对象合并，确保 formData 始终有默认值，不会变成 undefined
                            this.formData = Object.assign({}, this.formData, {
                                ylcdnaddon_can_update_account: data.ylcdnaddon_can_update_account || '0',
                            });
                        } else {
                            // API 返回错误，保持默认值
                            const errorMsg = (res && res.data && res.data.msg) ? res.data.msg : '获取配置失败';
                            this.$message.error(errorMsg);
                        }
                    } catch (error) {
                        // 网络错误或其他异常，保持默认值，formData 不会变成 undefined
                        console.error('获取配置异常:', error);
                        let errorMsg = '获取配置失败，请稍后重试';
                        if (error && error.data) {
                            if (error.data.msg) {
                                errorMsg = error.data.msg;
                            } else if (error.data.message) {
                                errorMsg = error.data.message;
                            }
                        } else if (error && error.message) {
                            errorMsg = error.message;
                        }
                        this.$message.error(errorMsg);
                    } finally {
                        this.loading = false;
                    }
                },
                // 保存配置
                async onSubmit({ validateResult, firstError }) {
                    if (validateResult === true) {
                        try {
                            this.submitLoading = true;
                            const params = JSON.parse(JSON.stringify(this.formData));
                            const res = await apiYlcdnSaveConfig(params);
                            if (res && res.data && res.data.status === 200) {
                                this.$message.success(res.data.msg || '保存成功');
                                // 重新获取配置，确保数据同步
                                await this.getIndexSetting();
                            } else {
                                const errorMsg = (res && res.data && res.data.msg) ? res.data.msg : '保存失败';
                                this.$message.error(errorMsg);
                            }
                        } catch (error) {
                            console.error('保存配置异常:', error);
                            let errorMsg = '保存配置失败，请稍后重试';
                            if (error && error.data) {
                                if (error.data.msg) {
                                    errorMsg = error.data.msg;
                                } else if (error.data.message) {
                                    errorMsg = error.data.message;
                                }
                            } else if (error && error.message) {
                                errorMsg = error.message;
                            }
                            this.$message.error(errorMsg);
                        } finally {
                            this.submitLoading = false;
                        }
                    } else {
                        console.log("Errors: ", validateResult);
                        this.$message.warning(firstError || '请检查表单填写');
                    }
                },
            },
        }).$mount(template);
        typeof old_onload == "function" && old_onload();
    };
})(window);

